/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import java.io.StringReader;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ResultParser {

    private static final String SELECTED_NODE = "selected";

    private XMLInputFactory factory;

    private XMLEventReader reader;

    public ResultParser() throws Exception {
        factory = XMLInputFactory.newInstance();
    }

    public CustomerResult parse(String resultXml) throws Exception {
        reader = factory.createXMLEventReader(new StringReader(resultXml));

        CustomerResult customerResult = new CustomerResult();
        getNextEvent(reader);
        getNextEvent(reader);

        customerResult.parse(reader);
        return customerResult;
    }

    public static boolean isSelected(StartElement startElement) {
        Attribute attribute = startElement.getAttributeByName(new QName(SELECTED_NODE));
        return attribute != null && strToBool(attribute.getValue());
    }

    public static XMLEvent getNextEvent(XMLEventReader reader) throws XMLStreamException {
        XMLEvent event = null;
        while (reader.hasNext() && (event = reader.nextEvent()).isCharacters());
        return event;
    }

    public static boolean strToBool(String value) {
        if (value != null && value.equals("1") || value.toLowerCase().equals("true")) return true;
        return false;
    }

    public static long strToLong(String value) {
        if (value != null && !"".equals(value)) {
            return Long.parseLong(value);
        }
        return 0;
    }

    public static void parseUnknownTag(XMLEventReader reader) throws Exception {
        while (reader.hasNext()) {
            XMLEvent subElement = ResultParser.getNextEvent(reader);
            if (subElement.isEndElement()) {
                break;
            } else {
                parseUnknownTag(reader);
            }
        }
    }
}
