/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchForm implements ResultEntity {
    private static final String TNT_MBOX_NODE      = "include-tnt-mbox";
    private static final String AUTO_COMPLETE_NODE = "autocomplete";

    private static final Logger LOG = LoggerFactory.getLogger(SearchForm.class);

    private boolean      includeTnTBox;
    private AutoComplete autoComplete;
    
    public void parse(XMLEventReader reader) throws Exception {
        LOG.debug("Parsing search form...");
        while( reader.hasNext() ) {
            XMLEvent event = ResultParser.getNextEvent(reader);
            if( event.isEndElement())
                break;
            
            StartElement startElement = event.asStartElement();
            String localPart = startElement.getName().getLocalPart();
            LOG.debug("Found node {}", localPart);
            if( localPart.equals(TNT_MBOX_NODE)) {
                includeTnTBox = ResultParser.strToBool(reader.nextEvent().asCharacters().getData());
                ResultParser.getNextEvent(reader);
            }
            else
            if( localPart.equals(AUTO_COMPLETE_NODE)) {
                autoComplete = new AutoComplete();
                autoComplete.parse(reader);
            }
            else {
                ResultParser.parseUnknownTag(reader);
            }
        }
        LOG.debug("Done parsing search form");
    }
    
    public boolean isIncludeTnTBox() {
        return includeTnTBox;
    }
    
    public AutoComplete getAutoComplete() {
        return autoComplete;
    }
}
