/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Suggestion extends AbstractResultEntity {
    private static final String WORD_NODE = "word";
    private static final String LINK_NODE = "link";
    
    private String  word;
    private String  queryString;
    
    public void parse(XMLEventReader reader) throws Exception {
        while( reader.hasNext() ) {
            XMLEvent nextEvent = ResultParser.getNextEvent(reader);
            if( nextEvent.isEndElement())
                break;
            
            StartElement element = nextEvent.asStartElement();

            String localPart = element.getName().getLocalPart();
            if(WORD_NODE.equals(localPart)) {
                String data = readData(reader);
                word = data;
                ResultParser.getNextEvent(reader);
            }
            else
            if( LINK_NODE.equals(localPart)) {
                String data = readData(reader);
                queryString = data;
                ResultParser.getNextEvent(reader);
            }
            else {
                ResultParser.parseUnknownTag(reader);
            }
        }
    }

    public String getWord() {
        return word;
    }
    
    public String getQueryString() {
        return queryString;
    }
}
