/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 * Copyright 2011 Adobe Systems Incorporated
 * All Rights Reserved.
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import java.util.ArrayList;
import java.util.List;

public class Suggestions extends AbstractResultEntity {

    private static final String AUTO_SEARCH_NODE = "auto-searched";

    private static final String SUGGESTION_LOW_RESULT_NODE = "suggestions-low-results";

    private static final String ORIG_QUERY_NODE = "orig-query";

    private static final String ITEM_NODE = "suggestion-item";

    private boolean autoSearched;

    private boolean suggestionLowResult;

    private String origQuery;

    private List<Suggestion> items;

    public Suggestions() {
        items = new ArrayList<Suggestion>();
    }

    public void parse(XMLEventReader reader) throws Exception {
        while (reader.hasNext()) {
            XMLEvent event = ResultParser.getNextEvent(reader);
            if (event.isEndElement()) { break; }

            StartElement startElement = event.asStartElement();
            String localPart = startElement.getName().getLocalPart();

            if (AUTO_SEARCH_NODE.equals(localPart)){
                String data = readData(reader);
                autoSearched = ResultParser.strToBool(data);
                ResultParser.getNextEvent(reader);
            } else if (SUGGESTION_LOW_RESULT_NODE.equals(localPart)) {
                String data = readData(reader);
                suggestionLowResult = ResultParser.strToBool(data);
                ResultParser.getNextEvent(reader);
            } else if (ORIG_QUERY_NODE.equals(localPart)) {
                String data = readData(reader);
                origQuery = data;
                ResultParser.getNextEvent(reader);
            } else if (ITEM_NODE.equals(localPart)) {
                Suggestion item = new Suggestion();
                item.parse(reader);
                items.add(item);
            } else {
                ResultParser.parseUnknownTag(reader);
            }
        }
    }

    public boolean isAutoSearched() {
        return autoSearched;
    }

    public boolean isSuggestionLowResult() {
        return suggestionLowResult;
    }

    public String getOrigQuery() {
        return origQuery;
    }

    public List<Suggestion> getItems() {
        return items;
    }
}
