/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.searchpromote.xml.result;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Zone extends AbstractResultEntity  {
    private static final String NAME_NODE    = "name";
    private static final String DISPLAY_NODE = "display";
    
    private String  name;
    private boolean display;
    
    public void parse(XMLEventReader reader) throws Exception {
        while( reader.hasNext() ) {
            XMLEvent nextEvent = ResultParser.getNextEvent(reader);
            if( nextEvent.isEndElement())
                break;
            
            StartElement element = nextEvent.asStartElement();

            String localPart = element.getName().getLocalPart();
            if( NAME_NODE.equals(localPart)) {
                String data = readData(reader);
                name = data;
                ResultParser.getNextEvent(reader);
            }
            else
            if(DISPLAY_NODE.equals(localPart)) {
                String data = readData(reader);
                display = ResultParser.strToBool( data );
                ResultParser.getNextEvent(reader);
            }
            else {
                ResultParser.parseUnknownTag(reader);
            }
        }
    }
    
    public String getName() {
        return name;
    }
    
    public boolean isDisplay() {
        return display;
    }
}
