/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security.privileges;

import com.day.cq.security.Authorizable;

import java.util.Collection;

/**
 * Allows applications to create custom {@link Privilege Privileges}.
 * Thus factories can create Privileges that implement custom rules
 * to {@link Privilege#isGranted(String)} grant}.
 * Factories are registred via SCR via providing this Interface as service.
 * <br>
 * The Factories get a {@link PrivilegeStore Privilege Store} to delegate the
 * management of their user-dependent configuration data.
 *
 * @see Privilege
 * @deprecated CQ 5.5
 */
public interface PrivilegeFactory {

    /**
     * Explicitly declare the Privileges this Factor is able to create Privileges
     * for.<br>
     * In case another Factory for one of the Privileges is already configured,
     * registration of this Factory fails
     *
     * @return collections of the {@link Privilege#getID() Privilege-ID}
     *         this factory registers for
     */
    Collection<String> handles();

    /**
     * The Factory creates an Privilege in any case.
     * @param privilegeId of the Privilege to create. must be contained in the set it {@link #handles() handles}
     * @param authorizable this privilege is created for
     * @param store containing configuration for the authorizable/privilege pair
     * @return Privilege created for the Authorizable
     */
    Privilege create(String privilegeId, Authorizable authorizable, PrivilegeStore store);
}
