/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security.privileges;

import com.day.cq.security.Authorizable;

import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import java.util.Collection;

/**
 * Storage for {@link Privilege Privileges'}
 * optional configuration data.<br>
 * Releaves {@link PrivilegeFactory
 * PrivilegeFactories} from the management and possible errors on protection etc.
 *
 * The Store provieds a {@link javax.jcr.Node Node} for each
 * Privilege-Authorizable combination. Which can be further used as persistence.
 * The Store must enforce proper access-rights.
 *
 * @deprecated CQ 5.5
 */
public interface PrivilegeStore {

    boolean hasPrivilege(Authorizable authorizable, String privilegePath)
            throws AccessDeniedException;

    Node getPrivilegeNode(Authorizable authorizable, String privilegePath)
            throws AccessDeniedException;

    Collection<String> getPrivileges(Authorizable authorizable)
            throws AccessDeniedException;

    void setPrivilege(Authorizable authorizable, String privilegePath)
            throws AccessDeniedException;

    void removePrivilege(Authorizable authorizable, String privilegePath)
            throws AccessDeniedException;
}
