/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security.resource;

import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;

import com.day.cq.security.Authorizable;

/**
 * Simple {@link org.apache.sling.api.resource.Resource Resource}
 * Implementation. A specialization is required, as Users is not necessarily a
 * {@link javax.jcr.Node Node} in the Repository. The Resource is
 * {@link org.apache.sling.api.adapter.Adaptable#adaptTo(Class) adaptable} to
 * the Authorizable it represents.
 *
 * @see UserResource
 * @see GroupResource
 * @see org.apache.sling.api.resource.Resource
 * @deprecated 5.4
 */
@Deprecated
public abstract class AuthorizableResource extends AbstractResource {

    private final Authorizable authorizable;

    private final ResourceResolver resolver;

    private final String path;

    private ResourceMetadata metadata;

    AuthorizableResource(Authorizable auth, String path, ResourceResolver resolver) {
        this.path = path;
        this.authorizable = auth;
        this.resolver = resolver;
        this.metadata = new ResourceMetadata();
    }

    //------------------------------------------------< Resource >--------------

    /**
     * {@inheritDoc}
     */
    public String getPath() {
        return path;
    }

    /**
     * {@inheritDoc}
     */
    public String getResourceType() {
        return AuthorizableResource.class.getName();
    }

    /**
     * {@inheritDoc}
     */
    public ResourceMetadata getResourceMetadata() {
        return metadata;
    }

    /**
     * {@inheritDoc}
     */
    public ResourceResolver getResourceResolver() {
        return resolver;
    }

    //------------------------------------------------< SlingAdaptable >--------
    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Authorizable.class) {
            return (AdapterType) authorizable;
        }
        return super.adaptTo(type);
    }

    Authorizable getAuthorizable() {
        return this.authorizable;
    }
}
