/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security.resource;

import com.day.cq.security.Group;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * Group implementation
 *
 * @see AuthorizableResource
 * @see org.apache.sling.api.resource.Resource
 * @deprecated 5.4
 */
public class GroupResource extends AuthorizableResource {

    public GroupResource(Group group, String path, ResourceResolver resolver) {
        super(group, path, resolver);
    }

    /**
     * Sets the Resource-Type to <code>com.day.cq.security.resource.GroupResource</code>
     *
     * @see org.apache.sling.api.resource.Resource#getResourceSuperType()
     */
    public String getResourceType() {
        return Group.class.getName();
    }

    /**
     * Sets the Resource-SuperType to <code>com.day.cq.security.resource.AuthorizableResource</code>
     *
     * @see org.apache.sling.api.resource.Resource#getResourceSuperType()
     */
    public String getResourceSuperType() {
        return super.getResourceType();
    }

    /**
     * Adds adaptability to {@link com.day.cq.security.Group Group}
     *
     * @param type to adapt to
     * @return Adapted object or <code>null</code> if not adapbtable
     * @see org.apache.sling.adapter.SlingAdaptable#adaptTo(Class)
     */
    @SuppressWarnings("unchecked")
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Group.class) {
            return (AdapterType) getAuthorizable();
        }
        return super.adaptTo(type);
    }
}
