/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security.util;

import java.security.Principal;

import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;

import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.sling.api.SlingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Tool to apply Access Control on a CRX Repository
 *
 * @deprecated Since CQ 5.3 Please use JCR API instead.
 */
@Deprecated
public class CRXPolicyManager {

    private final JackrabbitSession session;

    private final AccessControlManager acManager;

    private final PrincipalManager principalManager;

    private final static Logger log = LoggerFactory.getLogger(CRXPolicyManager.class);

    public CRXPolicyManager(Session session) throws RepositoryException {
        if (!(session instanceof JackrabbitSession)) {
            throw new RepositoryException("CRXPolicyManager only usable with a jackrabbit session.");
        }
        this.session = (JackrabbitSession) session;
        this.acManager = session.getAccessControlManager();
        this.principalManager = this.session.getPrincipalManager();
    }

    /**
     * Applies the Policy. Adds Entries to the Repository's ACL.
     * The ACL is only modified if the effective Permissions are changed by the
     * Policy given.<br>
     *
     * @param path to apply the Policy to
     * @param policy to apply
     * @return if the Repository changed
     * @throws AccessDeniedException the Session is not allowe to modify Access Control
     * @see #privatePolicy()
     * @see AclPolicy#AclPolicy(String, String[], boolean)
     */
    public boolean applyPolicy(String path, AclPolicy policy) throws AccessDeniedException {
        boolean success = false;
        try {
            boolean modified = false;
            if (session.itemExists(path)) {
                JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList(session, path);
                if (acl != null) {
                    for (AclPolicy.Entry entry : policy.getEntries()) {
                        if (principalManager.hasPrincipal(entry.getPrincipal())) {
                            Principal principal = principalManager.getPrincipal(entry.getPrincipal());
                            if (principal != null && acl.addEntry(principal, AccessControlUtils.privilegesFromNames(session, entry.getPrivileges()), entry.isAllow()))
                                modified = true;
                            log.debug("Allow not contained in ACL on {}: added for {}",
                                    path, principal.getName());
                        } else {
                            log.debug("Allow for {} contained in ACL on {}: no changes", entry.getPrincipal(), path);
                        }
                    }
                }
                if (modified) {
                    acManager.setPolicy(path, acl);
                    session.save();
                }
            }
            success = true;            
            return modified;
        } catch (AccessDeniedException e) {
            throw e;
        } catch (RepositoryException e) {
            throw new SlingException(e.getMessage(), e);
        } finally {
            // revert all pending changes in case of exception.
            if (!success) {
                try {
                    session.refresh(false);
                } catch (RepositoryException e) {
                    log.error("Failed to revert pending changes.", e);
                    throw new SlingException(e.getMessage(), e);
                }
            }
        }
    }

    /**
     * @return creates a Policy that initaly denies access to everybody
     */
    public AclPolicy privatePolicy() {
        return new AclPolicy(principalManager.getEveryone().getName(),
                new String[] {Privilege.JCR_ALL},
                false);
    }
}
