/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.spellchecker;

/**
 * This interface must be implemented by all services that provide means for spellchecking
 * a single word or an entire text.
 */
public interface SpellCheckService {

    /**
     * Spellchecks a single word.
     *
     * @param word The word to spellcheck
     * @param language Language of the word
     * @param dictionaryPaths Paths to dictionaries
     * @return The result of the spellchecking
     * @throws SpellCheckException in case of an error
     */
    WordCheckResult checkWord(String word, String language, String[] dictionaryPaths)
            throws SpellCheckException;

    /**
     * Spellchecks an entire text.
     *
     * @param text The text to spellcheck
     * @param language Language of the text
     * @param isHtml True if the text to check is in HTML format
     * @param dictionaryPaths Paths to dictionaries
     * @return The result of the spellchecking
     * @throws SpellCheckException in case of an error
     */
    TextCheckResult checkText(String text, String language, boolean isHtml,
                              String[] dictionaryPaths) throws SpellCheckException;

}
