/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.tagging;

import aQute.bnd.annotation.ProviderType;

/**
 * Constants for tagging, mainly JCR nodetype and property names.
 */
@ProviderType
public interface TagConstants {

    static final String NT_TAG = "cq:Tag";
    static final String NT_TAGGABLE = "cq:Taggable";
    
    static final String PN_TAGS = "cq:tags";
    
    static final String PN_MOVED_TO = "cq:movedTo";
    static final String PN_BACKLINKS = "cq:backlinks";
    
    static final String MARKED_AS_DELETED = "nirvana";
    
    static final char NAMESPACE_DELIMITER_CHR = ':';
    static final String NAMESPACE_DELIMITER = new String(new char[] {NAMESPACE_DELIMITER_CHR});
    static final String SEPARATOR = "/";
    
    static final String TITLEPATH_NS_DELIMITER = " " + NAMESPACE_DELIMITER_CHR + " "; 
    static final String TITLEPATH_DELIMITER = " " + SEPARATOR + " "; 
    
    static final String DEFAULT_NAMESPACE = "default";
    static final String DEFAULT_NAMESPACE_ID = DEFAULT_NAMESPACE + NAMESPACE_DELIMITER;
}
