/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.api;

import aQute.bnd.annotation.ProviderType;
import com.day.cq.commons.JSONItem;
import com.day.cq.commons.LabeledResource;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

import java.util.Calendar;

/**
 * Defines the interface of a CQ WCM template.
 */
@ProviderType
public interface Template extends Adaptable, LabeledResource, JSONItem {

    /**
     * Returns the path of the template resource
     * @return path
     */
    public String getPath();

    /**
     * Returns the title of the template or the name of the resource (i.e.
     * last path segment) if not defined.
     * @return title
     */
    public String getTitle();

    /**
     * Returns the short title of the template or <code>null</code>
     * if not defined.
     * @return short title
     */
    public String getShortTitle();

    /**
     * Returns the description of the template or <code>null</code> if not
     * defined.
     * @return description
     */
    public String getDescription();

    /**
     * Returns the path to an icon for this template or <code>null</code> if
     * this template does not provide an icon.
     *
     * @return the path to an icon or <code>null</code>
     */
    String getIconPath();

    /**
     * Returns the path to a thumbnail for this template or <code>null</code>
     * if the template does not provide a thumbnail.
     * 
     * @return the path to a thumbnail or <code>null</code>
     */
    String getThumbnailPath();

    /**
     * Returns the ranking in the template list.
     *
     * @return the ranking
     */
    Long getRanking();

    /**
     * Checks if this template is allowed to be used for a new page below
     * the given path.
     *
     * Note: This template is not allowed, if the parent template cannot be
     * evaluated but the template specifies "allowedParents"
     *
     * Always use {@link #isAllowed(Resource)} in loops for better performance.
     *
     * @param parentPath parent path for the new page
     * @return <code>true</code> if it is allowed.
     */
    boolean isAllowed(String parentPath);

    /**
     * Checks if this template is allowed to be used for a new page below
     * the given parent.
     *
     * Note: This template is not allowed, if the parent template cannot be
     * evaluated but the template specifies "allowedParents"
     *
     * @param parent the parent resource for the new page
     * @return <code>true</code> if it is allowed.
     */
    boolean isAllowed(Resource parent);

    /**
     * Checks if the given template is allowed as a child template.
     * @param template the child template
     * @return <code>true</code> if the given template is allowed as child template.
     */
    boolean isAllowedChild(Template template);

    /**
     * {@inheritDoc}
     */
    public void write(JSONWriter jsonWriter) throws JSONException;


    /**
     *
     * @return
     */
    public String getInitialContentPath();

    /**
     * Get the template's properties.
     *
     * @return The template's properties. Never returns <code>null</code>.
     */
    public ValueMap getProperties();

    /**
     *
     * @return
     */
    public boolean hasStructureSupport();

    /**
     * Get page type
     * @return
     */
    public String getPageTypePath();

    /**
     * Get last modified date of template
     * @return
     */
    public Calendar getLastModified();

}
