/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/
package com.day.cq.wcm.api;

import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

import java.util.List;

/**
 * Template Manger API.
 *
 * API for managing 'authored' templates and related components.
 */
public interface TemplateManager {

    /**
     * Creates a new template
     *
     * @return
     */
    public Template createTemplate(String parentPath, String templateType, String templateName, ValueMap templateProperties) throws WCMException;

    /**
     * @param template
     *
     * @throws com.day.cq.wcm.api.WCMException is thrown if the template is still used on pages.
     */
    public void deleteTemplate(Template template) throws WCMException;

    /**
     * @param template
     *
     * @return
     */
    public List<Page> getContainingPages(Template template);


    /**
     * @param componentContext
     *
     * @return
     */
    public List<Resource> getStructureResources(ComponentContext componentContext);

    /**
     * @param resource
     *
     * @return
     */
    public Template getContainingTemplate(Resource resource);

    /**
     * @return
     */
    public List<Template> getAllTemplates();


    /**
     * @param filter
     *
     * @return
     */
    public List<Template> getTemplates(Predicate filter);

    /**
     * @param templatePath
     *
     * @return
     */
    public Template getTemplate(String templatePath);

    /**
     * Get template types
     *
     * @return
     */
    public List<Template> getTemplateTypes(String parentPath);

}
