/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.api.commands;

import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;

import com.day.cq.wcm.api.PageManager;

/**
 * <code>WCMCommand</code>...
 */
public interface WCMCommand {

    /**
     * default path parameter name
     */
    public static final String PATH_PARAM = "path";

    /**
     * parent path
     */
    static final String PARENT_PATH_PARAM = "parentPath";

    /**
     * source path
     */
    static final String SRC_PATH_PARAM = "srcPath";

    /**
     * source path List
     */
    static final String SRC_PATH_LIST_PARAM = "srcPathList";

    /**
     * destination parent path
     */
    static final String DEST_PARENT_PATH_PARAM = "destParentPath";

    /**
     * destination path
     */
    static final String DEST_PATH_PARAM = "destPath";

    /**
     * destination name
     */
    static final String DEST_NAME_PARAM = "destName";

    /**
     * adjust (for heavy move)
     */
    static final String ADJUST_PARAM = "adjust";

    /**
     * publish (for heavy move)
     */
    static final String PUBLISH_PARAM = "publish";

    /**
     * integrity (for heavy move)
     */
    static final String INTEGRITY_PARAM = "integrity";

    /**
     * before param
     */
    static final String BEFORE_PARAM = "before";

    /**
     * page label
     */
    static final String PAGE_LABEL_PARAM = "label";

    /**
     * page title
     */
    static final String PAGE_TITLE_PARAM = "title";

    /**
     * template path
     */
    static final String TEMPLATE_PARAM = "template";

    /**
     * shallow flag
     */
    static final String SHALLOW_PARAM = "shallow";

    /**
     * shallow list flag
     */
    static final String SHALLOW_LIST_PARAM = "shallowList";

    /**
     * force flag
     */
    static final String FORCE_PARAM = "force";

    /**
     * version name
     */
    static final String REVISION_ID_PARAM = "id";

    /**
     * date to restore to
     */
    static final String DATE_PARAM = "date";
    
    /**
     * Returns the name of the command.
     * @return the name of the command
     */
    String getCommandName();

    /**
     * Peformas the command. If the response is handled by the command it self,
     * it must return <code>null</code>.
     *
     * @param ctx the command context. i.e. the command servlet.
     * @param request the servlet request
     * @param response the servlet response
     * @param pageManager the page manager
     * @return the html response or <code>null</code>.
     */
    HtmlResponse performCommand(WCMCommandContext ctx,
                                SlingHttpServletRequest request,
                                SlingHttpServletResponse response,
                                PageManager pageManager);


}