package com.day.cq.wcm.api.components;

import com.day.cq.commons.JSONItem;
import com.day.cq.wcm.api.NameConstants;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.jcr.resource.JcrPropertyMap;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

/**
 * Specifies a child editor as configured in the inplace edit config.
 */
public class ChildEditor implements JSONItem {

    /**
     * Name of property containing the inplace child editor's title
     */
    private final String PN_CE_TITLE = "title";

    /**
     * Name of property containing the inplace child editor's type
     */
    private final String PN_CE_TYPE = "type";

    /**
     * Name of property containing the inplace child editor's icon
     */
    private final String PN_CE_ICON = "icon";

    private final String name;

    private final String id;

    private final String title;

    private final String icon;

    private final String type;

    public ChildEditor(Node node) throws RepositoryException {
        JcrPropertyMap map = new JcrPropertyMap(node);
        name = node.getName();
        id = name;
        type = map.get(PN_CE_TYPE, "");
        title = map.get(PN_CE_TITLE, "");
        icon = map.get(PN_CE_ICON, "");
    }

    public String getName() {
        return name;
    }

    public String getId() {
        return id;
    }

    public String getTitle() { return title; }

    public String getType() {
        return type;
    }

    public String getIcon() {
        return icon;
    }

    public void write(JSONWriter out) throws JSONException {
        out.object();
        out.key("id").value(name);
        out.key(PN_CE_TYPE).value(type);
        out.key(PN_CE_TITLE).value(title);
        out.key(PN_CE_ICON).value(icon);
        out.endObject();
    }
}