/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.wcm.api.components;

import java.util.Map;

import com.day.cq.commons.JSONItem;

/**
 * Defines the edit control configuration. A JSON serialized form needs to be
 * written to the response when drawing the 'edit control'.
 */
public interface ComponentEditConfig extends JSONItem {

    /**
     * Checks if this config has all default values in respect to the default
     * values of the widgets. If <code>true</code> the edit config does not
     * need to be submitted to the client.
     * @return <code>true</code> if default
     */
    boolean isDefault();

    /**
     * Returns the edit layout for the edit control widget.
     * @return the edit layout for the edit control widget.
     */
    EditLayout getLayout();

    /**
     * Returns a unmodifiable map of configurations of drop targets.
     * the keys are the ids of the configs.
     *
     * @return map of drop target configurations.
     */
    Map<String, DropTarget> getDropTargets();

    /**
     * Returns the display mode of the dialog
     * @return the dialog mode.
     */
    DialogMode getDialogMode();

    /**
     * Returns the configuration for inplace editing of this configuration.
     * @return The inplace editing config; <code>null</code> if there is no inplace editing
     *         config (which means that no inplace editing is available for the component)
     * @since 5.3
     */
    InplaceEditingConfig getInplaceEditingConfig();

    /**
     * Returns the insert behavior or <code>null</code> of not defined
     * @return insert behavior or <code>null</code>
     */
    String getInsertBehavior();

    /**
     * Returns the <code>empty</code> flag. Indicates if the respective
     * component has no visual content and a placeholder text should be
     * rendered.
     *
     * @return <code>true</code> if a placeholder text should be rendered
     */
    boolean isEmpty();

    /**
     * Gets the text to be displayed when {@link #isEmpty()} is <code>true</code>.
     * Returns <code>null</code> if the default text is displayed.
     *
     * @return the empty text or <code>null</code>
     */
    String getEmptyText();

    /**
     * Returns if the edited component is orderable.
     *
     * @return <code>true</code> if the component is orderable or <code>null</code>
     *         if the behavior is defined by the widgets.
     */
    Boolean isOrderable();

    /**
     * Returns the (unmodifiable) toolbar for the editbar/menu.
     * @return toolbar
     */
    Toolbar getToolbar();

    /**
     * Returns an unmodifiable map for additional form parameters to be included
     * in the dialog.
     * @return map of additional form parameters
     */
    Map<String, String> getFormParameters();
    
    /**
     * Returns the additional form parameters to be included in the dialog. 
     * This method allows to use multi value properties for form parameters.
     * @return map of additional form parameters
     */
    Map<String, Object> getFormParameterMap();

    /**
     * Returns an unmodifiable map of edit listeners.
     * @return map of edit listeners
     */
    Map<String, String> getListeners();

    /**
     * Returns the component live relationship.
     * TODO seems like we are only considering this as an additional JSONItem
     * 	to render - if that's confirmed we might rename this method.
     * @return the computed live relationship. <code>null</code> otherwise
     */
    JSONItem getLiveRelationship();

    /**
     * Returns if cancelling inheritance of the component sets the cq:isCancelledForChildren flag or not.
     *
     * @return <code>true</code> if cancel sets the flag or <code>null</code>
     *         if cancel does not set the flag.
     */
    Boolean isDeepCancel();

    /**
     * Returns if targeting is disabled for this component.
     *
     * @return <code>true</code> if targeting is disabled, <code>false</code> if targeting is allowed
     */
    boolean isTargetingDisabled();
}