/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.wcm.api.components;

import org.apache.sling.commons.json.JSONString;

/**
 * Defines the mode of dialog where "floating" means that the dialog floats
 * above the page and "inline" means that the dialog is inlined in the page.
 * "auto" uses some UI metrics to define the mode of the dialog.
 */
public enum DialogMode implements JSONString {

    /**
     * automatic mode detection
     */
    AUTO("CQ.wcm.EditBase.INLINE_MODE_AUTO"),

    /**
     * floating dialog mode
     */
    FLOATING("CQ.wcm.EditBase.INLINE_MODE_NEVER"),

    /**
     * inline dialog mode
     */
    INLINE("CQ.wcm.EditBase.INLINE_MODE_FORCED");

    /**
     * the js type, i.e. the javascript constant used by the widgets.
     */
    private final String jsType;

    /**
     * internal constructor
     * @param jsType the js type
     */
    DialogMode(String jsType) {
        this.jsType = jsType;
    }

    /**
     * {@inheritDoc}
     */
    public String toJSONString() {
        return jsType;
    }

}