/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.wcm.api.components;

import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONString;
import org.apache.sling.commons.json.io.JSONWriter;

/**
 * Defines the current predefined edit control actions for the ext widgets.
 */
public enum EditAction implements JSONString, Toolbar.Item {

    /**
     * Edit action
     */
    EDIT("CQ.wcm.EditBase.EDIT"),

   /**
     * Delete action
     */
    DELETE("CQ.wcm.EditBase.DELETE"),

    /**
     * Insert action
     */
    INSERT("CQ.wcm.EditBase.INSERT"),

    /**
     * Cut/Copy/Paste actions
     */
    COPYMOVE("CQ.wcm.EditBase.COPYMOVE"),

    /**
     * Edit/Delete actions
     */
    EDITDELETE("CQ.wcm.EditBase.EDITDELETE"),

    /**
     * Edit/Annotate/Delete actions
     */
    EDITANNOTATEDELETE("CQ.wcm.EditBase.EDITANNOTATEDELETE"),

    /**
     * Edit/Annotate/Delete/Insert actions
     */
    EDITANNOTATEDELETEINSERT("CQ.wcm.EditBase.EDITANNOTATEDELETEINSERT"),

    /**
     * Edit/Delete/Insert actions
     */
    EDITDELETEINSERT("CQ.wcm.EditBase.EDITDELETEINSERT"),

    /**
     * Edit/Annotate/Cut/Copy/Paste/Delete/Insert actions
     */
    EDITANNOTATECOPYMOVEDELETEINSERT("CQ.wcm.EditBase.EDITANNOTATECOPYMOVEDELETEINSERT"),

    /**
     * Edit/Annotate actions
     */
    EDITANNOTATE("CQ.wcm.EditBase.EDITANNOTATE"),

    /**
     * Edit/Cut/Copy/Paste/Delete/Insert actions
     */
    EDITCOPYMOVEDELETEINSERT("CQ.wcm.EditBase.EDITCOPYMOVEDELETEINSERT"),

    /**
     * Edit/Annotate/Copy/Move/Insert actions
     */
    EDITANNOTATECOPYMOVEINSERT("CQ.wcm.EditBase.EDITANNOTATECOPYMOVEINSERT"),

    /**
     * Edit/Copy/Move/Insert actions
     */
    EDITCOPYMOVEINSERT("CQ.wcm.EditBase.EDITCOPYMOVEINSERT"),

    /**
     * virtual action that clears inheritance
     */
    _CLEAR(null);

    /**
     * the js type, i.e. the javascript constant used by the widgets.
     */
    private final String jsType;

    /**
     * Internal constructor
     * @param type the js type
     */
    private EditAction(String type) {
        this.jsType = type;
    }

    /**
     * Returns the js type, i.e. the javascript constant used by the widgets.
     * @return the js type
     */
    public String toJSONString() {
        return jsType;
    }

    /**
     * {@inheritDoc}
     */
    public void write(JSONWriter writer) throws JSONException {
        if (jsType != null) {
            writer.value(this);
        }
    }
}