/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.api.designer;

import com.day.cq.commons.JSONItem;

/**
 * Defines a component style that is usually stored in the design. The component
 * styles are stored in the {@value #PN_CSS_CLASS} property and automatically
 * added to the component css during the component include.
 * @since 5.4
 */
public interface ComponentStyle extends JSONItem {

    /**
     * default property name to store component style cssc class names
     */
    static final String PN_CSS_CLASS = "cq:cssClass";

    /**
     * Returns the name of this component style
     * @return the name
     */
    String getName();

    /**
     * Returns the path where this component style is stored.
     * @return the path.
     */
    String getPath();

    /**
     * Returns the display title of this component style.
     * @return the title
     */
    String getTitle();

    /**
     * Returns the display description of this component style.
     * @return the description
     */
    String getDescription();

    /**
     * Returns an array of selectable style options
     * @return the options.
     */
    Option[] getOptions();

    /**
     * define a selectable style option
     */
    interface Option extends JSONItem {

        /**
         * Emprty array
         */
        static final Option[] EMPTY_ARRAY = new Option[0];

        /**
         * Returns the value of this option
         * @return the value
         */
        String getValue();

        /**
         * Returns the text of this option
         * @return the text
         */
        String getText();

        /**
         * Returns the description of this option
         * @return the option
         */
        String getDescription();

        /**
         * Returns the icon path of this option
         * @return the icon path.
         */
        String getIcon();
    }
}