/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.api.devicedetection;

import com.day.cq.wcm.api.Page;

public interface DeviceIdentificationMode {

	static final String SERVER_SIDE = "server-side";
	static final String CLIENT_SIDE = "client-side";
	static final String NONE = "none";
	static final String DEVICE_IDENTIFICATION_MODE_PROPERTY = "cq:deviceIdentificationMode";
	
	static final String TOPIC_DIM_ADDED = "com/day/cq/wcm/api/devicedetection/DIM/ADDED";
	static final String TOPIC_DIM_CHANGED = "com/day/cq/wcm/api/devicedetection/DIM/CHANGED";
	static final String TOPIC_DIM_REMOVED = "com/day/cq/wcm/api/devicedetection/DIM/REMOVED";

	/**
	 * Returns the currently used device identification mode for a page by searching for the jcr:content/cq:deviceIdentificationMode
	 * property on the node representing the path. If the property is not found, the lookup has to continue by scanning parent nodes. If the
	 * property is not found, it is assumed that the value is DeviceIdentificationMode.SERVER_SIDE.
	 * 
	 * @param page
	 *            the page for which the device identification mode is analysed
	 * @return the device identification mode as String
	 */
	String getDeviceIdentificationModeForPage(Page page);

}
