/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.api.msm;

import java.util.Collection;
import java.util.Map;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMException;

/**
 * @deprecated since 5.3 use {@link com.day.cq.wcm.msm.api.LiveRelationshipManager} instead
 */
@Deprecated
public interface LiveRelationshipManager {

    /**
     * Returns all live copies. the Live Copy path is used as key of the map.
     * @return all live copies.
     */
    Map<String, LiveCopy> getLiveCopies();

    /**
     * Returns the closest Live Copy corresponding the <code>target</code> resource.
     * @param target resource
     * @return Live Copy or null if no Live Copy found.
     */
    LiveCopy getLiveCopy(Resource target);

    /**
     * Returns a collection of live relationships of the given Live Copy source
     * page to its targets. The search can be limited by trigger or target by
     * specifying the respective parameters. The given source page does not need
     * to be a Live Copy root.
     *
     * @param source source page
     * @param trigger filter for triggers
     * @param targets filter for targets
     * @param advancedStatus True if advanced status (time consuming) must be computed for relationships
     * @return the relationships
     * @throws WCMException if an error occurs
     */
    Collection<LiveRelationship> getLiveRelationships(Page source,
                                                RolloutManager.Trigger trigger,
                                                String[] targets,
                                                boolean advancedStatus)
            throws WCMException;

    /**
     * Returns a collection of live relationships of the given livecopy source
     * resource to its targets. The search can be limited by trigger or target
     * by specifying the respective parameters. The given source resource does
     * not need to be a livecopy root.
     *
     * @param source resource
     * @param trigger filter for triggers
     * @param targets filter for targets
     * @param advancedStatus True if advanced status (time consuming) must be computed for relationships
     * @return the relationships
     * @throws WCMException if an error occurrs
     */
    Collection<LiveRelationship> getLiveRelationships(Resource source,
                                                RolloutManager.Trigger trigger,
                                                String[] targets,
                                                boolean advancedStatus)
            throws WCMException;

    /**
     * Returns a live relationship of the given livecopy sync resource.
     *
     * @param target the livecopy sync resource
     * @param advancedStatus True if advanced status (time consuming) must be computed for relationship
     * @return the relationship or <code>null</code> if the resource is not a livecopy
     * @throws WCMException if an error occurrs
     */
    LiveRelationship getLiveRelationship(Resource target, boolean advancedStatus) throws WCMException;

    /**
     * Checks if the given sync target is part of a Live Copy relationship.
     * @param target the resource to check
     * @return <code>true</code> if the resource is live synced
     */
    boolean isLiveCopy(Resource target);

    /**
     * Checks if the given source is in a blueprint tree.
     * @param source the resource to check
     * @return <code>true</code> if the resource is a blueprint
     */
    boolean isInBlueprint(Resource source);

    /**
     * Checks if the given source is the source of a Live Copy relationship.
     * @param resource the resource to check
     * @return <code>true</code> if the resource is a blueprint
     */
    boolean isSource(Resource resource);

    /**
     * Cancel the relationship of the given relation.
     * @param resolver resource resolver
     * @param relation relation
     * @param deep if <code>true</code> all child relations are canceled, too
     * @param autoSave  Save modifications
     * @throws WCMException if an error occurs
     */
    void cancelRelationship(ResourceResolver resolver, LiveRelationship relation,
                            boolean deep, boolean autoSave)
            throws WCMException;

    /**
     * Reenable the relationship of a canceled one.
     * @param resolver resource resolver
     * @param relation relation to re-enable
     * @param autoSave  Save modifications
     * @throws WCMException if an error occurs
     */
    void reenableRelationship(ResourceResolver resolver, LiveRelationship relation, boolean autoSave)
            throws WCMException;

    /**
     * Cancels or reenables the relationship based on the relation status.
     * @param resolver resource resolver
     * @param relation relation to toggle
     * @param deep if <code>true</code> all child relations will be cancelled, too
     * @param autoSave  Save modifications
     * @throws WCMException if an error occurs
     */
    void toggleRelationship(ResourceResolver resolver, LiveRelationship relation,
                            boolean deep, boolean autoSave)
            throws WCMException;
    
    /**
     * Cancel the relationship of the given relation.
     * @param resolver resource resolver
     * @param relation relation
     * @param names list of property names for which inheritance is canceled
     * @param autoSave  Save modifications
     * @throws WCMException if an error occurs
     */
    void cancelPropertyRelationship(ResourceResolver resolver,
            LiveRelationship relation, String[] names, boolean autoSave)
            throws WCMException;

    /**
     * Reenable the relationship of a canceled one.
     * @param resolver resource resolver
     * @param relation relation to re-enable
     * @param names list of property names for which inheritance is reenabled
     * @param autoSave  Save modifications
     * @throws WCMException if an error occurs
     */
    void reenablePropertyRelationship(ResourceResolver resolver,
            LiveRelationship relation, String[] names, boolean autoSave) throws WCMException;

    /**
     * Cancel the relationship of the given relation. Saves the modifications.
     * @param resolver resource resolver
     * @param relation relation
     * @param deep if <code>true</code> all child relations are canceled, too
     * @throws WCMException if an error occurs
     * @deprecated Use {@link #cancelRelationship(ResourceResolver resolver, LiveRelationship relation,
                            boolean deep, boolean autoSave)} instead.
     */
    @Deprecated
    void cancelRelationship(ResourceResolver resolver, LiveRelationship relation,
                            boolean deep)
            throws WCMException;

    /**
     * Reenable the relationship of a canceled one. Saves the modifications.
     * @param resolver resource resolver
     * @param relation relation to re-enable
     * @throws WCMException if an error occurs
     * @deprecated Use {@link #reenableRelationship(ResourceResolver resolver, LiveRelationship relation,
                            boolean autoSave)} instead.
     */
    @Deprecated
    void reenableRelationship(ResourceResolver resolver, LiveRelationship relation)
            throws WCMException;

    /**
     * Cancels or reenables the relationship based on the relation status. Saves the modifications.
     * @param resolver resource resolver
     * @param relation relation to toggle
     * @param deep if <code>true</code> all child relations will be cancelled, too
     * @throws WCMException if an error occurs
     * @deprecated Use {@link #toggleRelationship(ResourceResolver resolver, LiveRelationship relation,
                            boolean deep, boolean autoSave)} instead.
     */
    @Deprecated
    void toggleRelationship(ResourceResolver resolver, LiveRelationship relation,
                            boolean deep)
            throws WCMException;

    /**
     * Returns a map of pairs: Live Copy skipped page's path / <b>Blueprint page</b>. Each Live Copy skipped page's
     * path is the path of a skipped child of the provided page and returned map contains its
     * corresponding Blueprint page.
     *
     * @param parentTargetPage Parent target page
     * @return the map
     * @throws WCMException if an error occurs
     */
    public Map<String, Page> getSkippedSourcePages(Page parentTargetPage) throws WCMException;

    /**
     * Adds a page to the skipped pages list (stored on parent page).
     *
     * @param parentPage Parent page
     * @param autoSave   Save modifications
     * @throws WCMException if an error occurs
     */
    public void addSkippedPage(Page parentPage, String childName, boolean autoSave) throws WCMException;

    /**
     * Adds several pages to the skipped pages list (stored on parent page).
     *
     * @param parentPage Parent page
     * @param autoSave   Save modifications
     * @throws WCMException if an error occurs
     */
    public void addSkippedPages(Page parentPage, String[] childName, boolean autoSave) throws WCMException;

    /**
     * Removes a page from the skipped pages list (stored on parent page).
     *
     * @param parentPage Parent page
     * @param autoSave   Save modifications
     * @throws WCMException if an error occurs
     */
    public void removeSkippedPage(Page parentPage, String childName, boolean autoSave) throws WCMException;

    /**
     * Removes several pages from the skipped pages list (stored on parent page).
     *
     * @param parentPage Parent page
     * @param autoSave   Save modifications
     * @throws WCMException if an error occurs
     */
    public void removeSkippedPages(Page parentPage, String[] childName, boolean autoSave) throws WCMException;
}