/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/
package com.day.cq.wcm.api.policies;

import java.util.List;

import aQute.bnd.annotation.ProviderType;
import com.day.cq.wcm.api.components.ComponentContext;

/**
 * Content Policy Manager API.
 */
@ProviderType
public interface ContentPolicyManager {

    /**
     * Get the <code>ContentPolicy</code> for the given <code>ComponentContext</code>.
     *
     * @param componentContext The mandatory component context to get the content policy for.
     *
     * @return The content policy for the given component context or <code>null</code> if none is configured.
     * @throws java.lang.IllegalArgumentException This exception is thrown, if the given component context is
     * <code>null</code>.
     */
    public ContentPolicy getPolicy(ComponentContext componentContext);

    /**
     * Returns the list of policies for the given path
     *
     * @param path Path from where to start searching for policies
     *
     * @return
     */
    public List<ContentPolicy> getPolicies(String path);

    /**
     * Returns the list of policies for the given path. Here you can limit search to the given policy resource type
     *
     * Policy Resource Types are relative {@see ResourceResolver}
     *
     * @param path Path from where to start searching for policies
     * @param policyResourceType Sling resource type associated with the policies
     * @return
     */
    public List<ContentPolicy> getPolicies(String path, String policyResourceType);

    /**
     * @param originalPolicy
     * @param newTitle
     * @param newDescription
     *
     * @return
     */
    public ContentPolicy copyPolicy(ContentPolicy originalPolicy, String newTitle, String newDescription);

    /**
     * @param contentPolicy
     *
     * @return
     */
    public List<ContentPolicyMapping> getPolicyMappings(ContentPolicy contentPolicy);


}
