/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.api.reference;

import java.util.List;

import org.apache.sling.api.resource.Resource;

/**
 * The <tt>ReferencedResourceProvider</tt> finds references to a specific resource
 * 
 */
public interface ReferenceProvider {

    /**
     * Finds references to a specific resource
     * 
     * @param resource the resource to find references to, never null
     * @return a list of references, possibly empty but never null
     */
    List<Reference> findReferences(Resource resource);
}
