/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2011 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.cq.wcm.api.variants;

import java.util.Map;

/** A PageVariant represents content that's similar to a given
 *  page, in another site variant. For example, the english version
 *  of a french page that a website visitor is looking at. 
 */
public interface PageVariant {
    /** The content path of the variant */
    String getPath();
    
    /** The full URL of the variant */
    String getURL();
    
    /** The title of the variant */
    String getTitle();
    
    /** Additional attributes of the variant (hreflang, media, etc) */
    Map<String, String> getAttributes();
}
