/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.commons.search;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;

/**
 * <code>GQL</code> is a simple fulltext query language, which supports field
 * prefixes similar to Lucene or Google queries.
 * <p/>
 * GQL basically consists of a list of query terms that are optionally prefixed
 * with a property name. E.g.: <code>title:jackrabbit</code>. When a property
 * prefix is omitted, GQL will perform a fulltext search on all indexed
 * properties of a node. There are a number of pseudo properties that have
 * special meaning:
 * <ul>
 * <li><code><b>path:</b></code> only search nodes below this path. If you
 * specify more than one term with a path prefix, only the last one will be
 * considered.</li>
 * <li><code><b>type:</b></code> only return nodes of the given node types. This
 * includes primary as well as mixin types. You may specify multiple comma
 * separated node types. GQL will return nodes that are of any of the specified
 * types.</li>
 * <li><code><b>order:</b></code> order the result by the given properties. You
 * may specify multiple comma separated property names. To order the result in
 * descending order simply prefix the property name with a minus. E.g.:
 * <code>order:-name</code>. Using a plus sign will return the result in
 * ascending order, which is also the default.</li>
 * <li><code><b>limit:</b></code> limits the number of results using an
 * interval. E.g.: <code>limit:10..20</code> Please note that the interval is
 * zero based, start is inclusive and end is exclusive. You may also specify an
 * open interval: <code>limit:10..</code> or <code>limit:..20</code> If the dots
 * are omitted and only one value is specified GQL will return at most this
 * number of results. E.g. <code>limit:10</code> (will return the first 10
 * results)</li>
 * </ul>
 * <p/>
 * <b>Property name</b>
 * <p/>
 * Instead of a property name you may also specify a relative path to a
 * property. E.g.: <code>"jcr:content/jcr:mimeType":text/plain</code>
 * <p/>
 * <b>Double quotes</b>
 * <p/>
 * The property name as well as the value may enclosed in double quotes. For
 * certain use cases this is required. E.g. if you want to search for a phrase:
 * <code>title:"apache jackrabbit"</code>. Similarly you need to enclose the
 * property name if it contains a colon: <code>"jcr:title":apache</code>,
 * otherwise the first colon is interpreted as the separator between the
 * property name and the value. This also means that a value that contains
 * a colon does not need to be enclosed in double quotes.
 * <p/>
 * <b>Auto prefixes</b>
 * <p/>
 * When a property, node or node type name does not have a namespace prefix GQL
 * will guess the prefix by looking up item and node type definitions in the
 * node type manager. If it finds a definition with a local name that matches
 * it will automatically assign the prefix that is in the definition. This means
 * that you can write: '<code>type:file</code>' and GQL will return nodes that are
 * of node type <code>nt:file</code>. Similarly you can write:
 * <code>order:lastModified</code> and your result nodes will be sorted by their
 * <code>jcr:lastModified</code> property value.
 * <p/>
 * <b>Common path prefix</b>
 * <p/>
 * For certain queries it is useful to specify a common path prefix for the
 * GQL query statement. See {@link #execute(String, Session, String)}. E.g. if
 * you are searching for file nodes with matches in their resource node. The
 * common path prefix is prepended to every term (except to pseudo properties)
 * before the query is executed. This means you can write:
 * '<code>type:file jackrabbit</code>' and call execute with three parameters,
 * where the third parameter is <code>jcr:content</code>. GQL will return
 * <code>nt:file</code> nodes with <code>jcr:content</code> nodes that contain
 * matches for <code>jackrabbit</code>.
 * <p/>
 * <b>Excerpts</b>
 * <p/>
 * To get an excerpt for the current row in the result set simply call
 * {@link Row#getValue(String) Row.getValue("rep:excerpt()");}. Please note
 * that this is feature is Jackrabbit specific and will not work with other
 * implementations!
 * @deprecated use {@link org.apache.jackrabbit.commons.query.GQL} instead.
 */
public final class GQL {

    /**
     * Executes the GQL query and returns the result as a row iterator.
     *
     * @param statement the GQL query.
     * @param session the session that will execute the query.
     * @return the result.
     */
    public static RowIterator execute(String statement,
                                      Session session) {
        return execute(statement, session, null);
    }

    /**
     * Executes the GQL query and returns the result as a row iterator.
     *
     * @param statement the GQL query.
     * @param session the session that will execute the query.
     * @param commonPathPrefix a common path prefix for the GQL query.
     * @return the result.
     */
    public static RowIterator execute(String statement,
                                      Session session,
                                      String commonPathPrefix) {
        return execute(statement, session, commonPathPrefix, null);
    }

    /**
     * Executes the GQL query and returns the result as a row iterator.
     *
     * @param statement the GQL query.
     * @param session the session that will execute the query.
     * @param commonPathPrefix a common path prefix for the GQL query.
     * @param filter an optional filter that may include/exclude result rows.
     * @return the result.
     */
    public static RowIterator execute(String statement,
                                      Session session,
                                      String commonPathPrefix,
                                      Filter filter) {
        return org.apache.jackrabbit.commons.query.GQL.execute(
                statement, session, commonPathPrefix, filter);
    }

    /**
     * Parses the given <code>statement</code> and generates callbacks for each
     * GQL term parsed.
     *
     * @param statement the GQL statement.
     * @param session   the current session to resolve namespace prefixes.
     * @param callback  the callback handler.
     * @throws RepositoryException if an error occurs while parsing.
     */
    public static void parse(String statement,
                             Session session,
                             ParserCallback callback)
            throws RepositoryException {
        org.apache.jackrabbit.commons.query.GQL.parse(statement, session, callback);
    }

    /**
     * Defines a filter for query result rows.
     *
     * @deprecated use {@link org.apache.jackrabbit.commons.query.GQL.Filter}
     *             instead.
     */
    public interface Filter
            extends org.apache.jackrabbit.commons.query.GQL.Filter {
    }

    /**
     * Defines a callback interface that may be implemented by client code to
     * get a callback for each GQL term that is parsed.
     *
     * @deprecated use {@link org.apache.jackrabbit.commons.query.GQL.ParserCallback}
     *             instead.
     */
    public interface ParserCallback
            extends org.apache.jackrabbit.commons.query.GQL.ParserCallback {
    }
}

