/*
 * Copyright 1997-2011 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.contentsync;

import javax.servlet.http.HttpServletResponse;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMException;

/**
 * This service allows you to export a page including referenced
 * resources as a zip.
 * 
 * @since 5.5
 */
public interface PageExporter {
	/**
	 * Export page and write to response.
	 * @param page		The page to export
	 * @param resolver	The resource resolver
	 * @param response	The response
	 */
	public void export(Page page, ResourceResolver resolver, HttpServletResponse response) throws WCMException;

	/**
	 * Export page and write to response.
	 * @param page		The page to export
	 * @param resolver	The resource resolver
	 * @param response	The response
	 */
	public void export(Page page, SlingHttpServletRequest request, HttpServletResponse response) throws WCMException;

	/**
	 * Export page and save zip at target location.
	 * @param page			The page to export
	 * @param resolver		The resource resolver
	 * @param targetPath	The target location
	 */
	public void export(Page page, ResourceResolver resolver, String targetPath) throws WCMException;
}
