/*
 * Copyright 1997-2011 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.contentsync;

import org.apache.commons.lang.StringUtils;

import java.util.HashMap;

/**
 * The <code>PathRewriterOptions</code> configure in which way
 * links and references should be rewritten. To enable path rewriting
 * you have to set an instance of <code>PathRewriterOptions</code> as
 * a request attribute.
 */
public class PathRewriterOptions extends HashMap<String, PathRewriterOptions.RewriteMode> {
	
	private static final long serialVersionUID = 7042302195945834350L;

	/** The request attribute name. */
	public static final String ATTRIBUTE_PATH_REWRITING_OPTIONS = "pathRewritingOptions";

	/**	 */
	public static final String OPTION_REWRITE_LINKS = "links";
	public static final String OPTION_REWRITE_CLIENTLIBS = "clientlibs";
	public static final String OPTION_REWRITE_IMAGES = "images";

    private String relativeParentPath;

	public PathRewriterOptions(RewriteMode links, RewriteMode clientlibs, RewriteMode images) {
		setRewriteMode(OPTION_REWRITE_LINKS, links);
		setRewriteMode(OPTION_REWRITE_CLIENTLIBS, clientlibs);
		setRewriteMode(OPTION_REWRITE_IMAGES, images);
	}
	
	public boolean isExternal(String option) {
		return getRewriteMode(option) == RewriteMode.REWRITE_EXTERNAL;
	}
	
	public boolean isRelative(String option) {
		return getRewriteMode(option) == RewriteMode.REWRITE_RELATIVE;
	}

    public boolean hasRelativeParent() { return StringUtils.isNotEmpty(relativeParentPath); }

	/**
	 * Get configured rewrite mode.
	 * @return the rewriteLinks
	 */
	public RewriteMode getRewriteMode(String option) {
		return get(option);
	}

	/**
	 * Set a new rewrite mode.
	 * @param mode The new rewrite mode
	 */
	public void setRewriteMode(String option, RewriteMode mode) {
		put(option, mode);
	}

    /**
     * Get configured relative parent path.
     * @return the relative parent path
     */
    public String getRelativeParentPath() {
        return relativeParentPath;
    }

    /**
     * Set a new relative parent.
     * @param path The new relative parent path
     */
    public void setRelativeParentPath(String path) {
        relativeParentPath = path;
    }

	/**
	 * Available rewrite modes.
	 */
	public enum RewriteMode {
		REWRITE_EXTERNAL,
		REWRITE_RELATIVE
	}
}
