/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.core.mvt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.PropertyIterator;
import javax.jcr.Property;

import org.apache.jackrabbit.util.Text;

import com.day.cq.wcm.api.Page;
import com.day.crx.statistics.Report;

/**
 * <code>CTRReport</code> implements a report that returns a click through rate
 * report about a page.
 */
@Deprecated
public class CTRReport extends Report {

    /** The page */
    private final Page page;

    /**
     * Creates a new report.
     *
     * @param dataPath the location where the result statistics are stored.
     * @param page     the page that was viewed
     */
    public CTRReport(String dataPath, Page page) {
        super(dataPath);
        this.page = page;
    }

    /**
     * {@inheritDoc} Returns result rows with the following objects:
     * <ul>
     * <li>Path <code>String</code> of the image/banner.</li>
     * <li><code>Long</code> impressions: how many times the image/banner was shown</li>
     * <li><code>Long</code> clicks: how many times the image/banner was clicked</li>
     * <li><code>Double</code> the click-through-rate</li>
     * </ul>
     */
    public Iterator<Object[]> getResult(Session session)
            throws RepositoryException {

        PageView view = new PageView(getDataPath(), page, "dummy");

        //skip if no statistics at all
        String monthPath = Text.getRelativeParent(view.getPath(), 1);
        if(!session.itemExists(monthPath)) {
            return Collections.<Object[]>emptySet().iterator();
        }

        Node month = (Node) session.getItem(monthPath);
        Map<String, Long> clicks = new HashMap<String, Long>();
        for (PropertyIterator props = month.getProperties(Click.CLICKS + "*"); props.hasNext(); ) {
            Property p = props.nextProperty();
            String rawPaths = p.getName().substring(Click.CLICKS.length());
            String paths[] = Text.explode(Text.unescapeIllegalJcrChars(rawPaths), '|');
            // TODO: for now only support one path
            if (paths.length == 1) {
                clicks.put(paths[0], p.getLong());
            }
        }

        Map<String, Long> views = new HashMap<String, Long>();
        for (PropertyIterator props = month.getProperties(PageView.VIEWS + "*"); props.hasNext(); ) {
            Property p = props.nextProperty();
            String rawPaths = p.getName().substring(PageView.VIEWS.length());
            String paths[] = Text.explode(Text.unescapeIllegalJcrChars(rawPaths), '|');
            // TODO: for now only support one path
            if (paths.length == 1) {
                views.put(paths[0], p.getLong());
            }
        }

        List<Object[]> data = new ArrayList<Object[]>();
        for (Map.Entry<String, Long> entry : views.entrySet()) {
            String path = entry.getKey();
            long v = entry.getValue();
            long c = clicks.containsKey(path) ? clicks.get(path) : 0;
            double ctr = 100d / v * c;
            data.add(new Object[]{path, v, c, ctr});
        }
        return data.iterator();
    }
}