/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.core.mvt;

import java.util.Calendar;

import javax.jcr.RepositoryException;
import javax.jcr.Node;
import javax.jcr.ValueFormatException;
import javax.jcr.Session;
import javax.jcr.Item;
import javax.jcr.PathNotFoundException;

import com.day.crx.statistics.Entry;
import com.day.crx.statistics.PathBuilder;
import com.day.cq.wcm.api.Page;

/**
 * <code>MVTEntry</code> is the base class for page view and click entries.
 */
@Deprecated
abstract class MVTEntry extends Entry {

    /** Name of the property that contains the count on a daily basis */
    protected final String count;

    /** Name of the property that contains the rolling week count */
    protected final String rollingWeekCount;

    /** Name of the property that contains the rolling month count */
    protected final String rollingMonthCount;

    /** The page */
    private final Page page;

    /**
     * Creates a new <code>PageView</code> instance.
     *
     * @param pathPrefix                the location where the entry information
     *                                  will be stored
     * @param countPropName             name of the property that contains the
     *                                  count on a daily basis.
     * @param rollingWeekCountPropName  name of the property that contains the
     *                                  rolling week count.
     * @param rollingMonthCountPropName name of the property that contains the
     *                                  rolling month count.
     * @param page                      the page that was viewed
     */
    public MVTEntry(String pathPrefix,
                    String countPropName,
                    String rollingWeekCountPropName,
                    String rollingMonthCountPropName,
                    Page page) {
        super(pathPrefix);
        this.count = countPropName;
        this.rollingWeekCount = rollingWeekCountPropName;
        this.rollingMonthCount = rollingMonthCountPropName;
        this.page = page;
    }

    /** {@inheritDoc} */
    protected PathBuilder getPathBuilder() {
        return new MVTPathBuilder(page.getPath());
    }

    /**
     * Writes the statistics to the passed node.
     *
     * @param node
     *            the node where to write the statistics
     * @throws RepositoryException
     *             if an error occurs while writing
     */
    @Override
    public void write(Node node) throws RepositoryException {
        Node month = node.getParent();
        Node year = month.getParent();

        updateViews(node);
        updateViews(month);
        updateViews(year);

        updateCumulativeViews(node, rollingWeekCount, 6);
        updateCumulativeViews(node, rollingMonthCount, 29);
    }

    /**
     * Increments the view count on the given <code>node</code>.
     *
     * @param node
     *            the node where to increment the view count
     * @throws RepositoryException
     *             if an error occurs while writing to the node.
     */
    private void updateViews(Node node) throws RepositoryException {
        long num = 0;
        if (node.hasProperty(count)) {
            num = node.getProperty(count).getLong();
        }
        node.setProperty(count, ++num);
    }

    /**
     * Updates a cumulative view count on the <code>node</code>.
     *
     * @param node
     *            the node where to update the cumulative view count
     * @param propertyName
     *            the name of the count property
     * @param numDays
     *            the number of days back in time that are cumulated
     * @throws RepositoryException
     *             if an error occurs while reading or updating.
     */
    private void updateCumulativeViews(Node node, String propertyName,
            int numDays) throws RepositoryException {
        long num;
        if (node.hasProperty(propertyName)) {
            num = node.getProperty(propertyName).getLong();
        } else {
            num = getCumulativeCount(node, numDays, count);
        }
        node.setProperty(propertyName, ++num);
    }

    private long getCumulativeCount(Node node, int numDays, String propName)
            throws RepositoryException, ValueFormatException {
        long num = 0;
        Session session = node.getSession();
        PathBuilder builder = getPathBuilder();
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(getTimestamp());
        PageView view = new PageView(getPathPrefix(), page, "dummy");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < numDays; i++) {
            // re-use buffer
            buffer.setLength(0);

            // go back one day
            date.add(Calendar.DAY_OF_MONTH, -1);
            view.setTimestamp(date.getTimeInMillis());
            builder.formatPath(view, buffer);
            String path = buffer.toString();
            try {
                Item item = session.getItem(path);
                if (item.isNode()) {
                    Node n = (Node) item;
                    if (n.hasProperty(propName)) {
                        num += n.getProperty(propName).getLong();
                    }
                }
            } catch (PathNotFoundException e) {
                // no statistics found for that day
            }
        }
        return num;
    }
}
