/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.core.mvt;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;

import javax.jcr.RepositoryException;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.day.cq.statistics.StatisticsService;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMException;

/**
 * Little utility for MVT-Statistics. Allows to configure the
 * {@link URL URL} to be called for tracking page-views and banner clicks.
 * Contains convenience for the running of the click through rate statistics.
 *
 * @see MVTStatistics
 */
@Deprecated
@Component(
		metatype=true,
		label="%mvtstatistics.name",
		description="%mvtstatistics.description"
)
@Service
public class MVTStatisticsImpl implements MVTStatistics {
    private final static Logger log = LoggerFactory
            .getLogger(MVTStatisticsImpl.class);

    @Property
    private static final String TRACKING_URL_PROPERTY = "mvtstatistics.trackingurl";

    @Reference(policy=ReferencePolicy.STATIC)
    private StatisticsService statistics; // set via scr

    private String trackingUrl;

    private String dataPath;

    // -----------------------------------------------< PageViewStatistics >----

    /**
     * @see MVTStatistics#getTrackingURL()
     */
    public URL getTrackingURL() {
        return getURL(trackingUrl);
    }
    
    /**
     * @see MVTStatistics#getTrackingURL(SlingHttpServletRequest)
     */
    public URI getTrackingURI() {
    	return getURI(trackingUrl);
    }

    /**
     * @see MVTStatistics#report(Page)
     */
    public Iterable<Object[]> report(Page page) throws WCMException {
        try {
            List<Object[]> result = new ArrayList<Object[]>();
            CTRReport report = new CTRReport(dataPath, page);
            for (Iterator<?> it = statistics.runReport(report); it.hasNext(); ) {
                result.add((Object[]) it.next());
            }
            return result;
        } catch (RepositoryException e) {
            throw new WCMException(e);
        }
    }

    // -----------------------------------------------< SCR Integration >-------

    protected void activate(ComponentContext context) {
        Dictionary<?, ?> props = context.getProperties();

        trackingUrl = (String) props.get(TRACKING_URL_PROPERTY);
        dataPath = statistics.getPath() + "/mvt";
    }

    // -----------------------------------------------< Internal >--------------

    private URL getURL(String urlProperty) {
        if (urlProperty != null) {
            try {
                return new URL(urlProperty);
            } catch (MalformedURLException e) {
                log.error("Configuration contained URL that is not valid{}: {}",
                        urlProperty, e);
            }
        }
        return null;
    }
    
    private URI getURI(String urlProperty) { 	
    	if (urlProperty != null) {        	
            try {
                return new URI(urlProperty);
            } catch (URISyntaxException e) {
                log.error("Configuration contained URI that is not valid{}: {}",
                		urlProperty, e);
            }
        }
        return null;
    }
}