/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.core.mvt;

import org.apache.jackrabbit.util.Text;

import com.day.cq.wcm.api.Page;
import com.day.crx.statistics.Entry;

/**
 * <code>PageView</code> provides an {@link Entry} for storing {@link Page}
 * views related to MVT statistics.
 */
@Deprecated
public class PageView extends MVTEntry {

    /** Prefix of the properties that contain the view count */
    public static final String VIEWS = "views-";

    /** Prefix of the properties that contain the rolling week count */
    public static final String ROLLING_WEEK_COUNT = "rollingWeekViews-";

    /** Prefix of the properties that contain the rolling month count */
    public static final String ROLLING_MONTH_COUNT = "rollingMonthViews-";

    /**
     * Creates a new <code>PageView</code> instance.
     *
     * @param pathPrefix the location where the entry information will be
     *                   stored
     * @param page       the page that was viewed
     * @param variables  the variable that were present when the page was
     *                   viewed.
     */
    public PageView(String pathPrefix, Page page, String variables) {
        super(pathPrefix,
                VIEWS + Text.escapeIllegalJcrChars(variables),
                ROLLING_WEEK_COUNT + Text.escapeIllegalJcrChars(variables),
                ROLLING_MONTH_COUNT + Text.escapeIllegalJcrChars(variables),
                page);
    }
}