/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.core.references;

import org.apache.sling.api.resource.Resource;

import com.adobe.granite.references.Reference;
import com.day.cq.rewriter.linkchecker.LinkInfo;

public class LinkReference extends Reference {

    private final LinkInfo linkInfo;

    public LinkReference(Resource source, Resource target,
            LinkInfo linkInfo, String type) {
        super(source, target, type);
        this.linkInfo = linkInfo;
    }

    /**
     * Returns the {@link LinkInfo} which contains information about validity of the link
     * 
     * @return The link info instance
     */
    public LinkInfo getLinkInfo() {
        return linkInfo;
    }
}
