/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter;

/**
 * This file contains all the error codes for design importer component.
 */
public class ErrorCodes {
    /**
     * Error code representing presence of multiple canvas div tags. Only one canvas div tag per HTML is allowed.
     */
    public final static String MULTIPLE_DIV_TAGS = "041"; //"Multiple canvas div tags encountered. The input HTML must contain exactly one canvas component tag."

    /**
     * Error code representing stray html content within a parsys component div tag. A parsys component div tag must only contain nested component div tags, nothing else.
     */
    public final static String PARSYS_NESTED_TAG = "042"; //"Illicit HTML content encountered. Parsys tag must only contain nested component tags."

    /**
     * Error code representing presence of canvas div tag nested within another canvas div tag. Only one canvas div tag is supported.
     */
    public static final String NESTED_CANVAS_COMPONENT = "043"; // "Nested canvas div tag encountered. The input HTML must contain exactly one canvas component tag."
                                                                //"Nested canvas div encountered"

    /**
     * Error code representing presence of stray html tag inside of an image component div tag. The image component div tag must only contain a valid img tag.
     */
    public static final String SINGLE_IMG_IMAGE = "044"; //"Image component div must contain exactly one &lt;img&gt; child";

    /**
     * Error code representing presence of stray text inside of an image component div tag. The image component div tag must only contain a valid img tag.
     */
    public static final String FLOATING_TEXT_SINGLE_IMG_IMAGE = "045"; //"Free floating text encountered. Image component div must contain exactly one &lt;img&gt; child";

    /**
     * Error code representing presence of an absolute url inside of an image component div tag. Only relative images are supported.
     */
    public static final String ABSOLUTE_URL_NOT_SUPPORTED = "046"; //"Absolute URL values not supported for &lt;img&gt; tags contained within the image component divs";

    /**
     * Error code representing presence of free floating text within a link tag.
     */
    public static final String FREE_FLOATING_TEXT_LINK_TAG = "047"; //"Free floating text is not supported within the link tag.";

    /**
     * Error code representing presence of free floating text within a script tag with src attribute defined. Note that inline scripts are supported, just the src attribute should be omitted.
     */
    public static final String FREE_FLOATING_TEXT_SCRIPT_TAG = "048"; //"Free floating text is not supported within the script tag.";

    /**
     * Error code representing presence of a component div tag nested within a text component div tag. The text component div tag only supports free floating text, markup or a mix of those two.
     */
    public static final String NESTED_COMPONENT_DIV_TAG_ENCOUNTERED_INSIDE_TEXT_COMPONENT_DIV_TAG = "049";//"Nested component div tag encountered inside text component div tag";

    /**
     * Error code representing non-conformance of title component div tag. The title component div tag must contain exactly one heading tag and no free floating text
     */
    public static final String TITLE_EXACTLY_ONE_HEADING_TAG =  "0411";//"Free floating text encountered. The title component must contain exactly one heading tag.";

    /**
     * Error code representing nested tags, other than the heading tags, inside of the title component div tag
     */
    public static final String TITLE_COMPONENT_UNKNOWN_TAG = "0412";//"The title component must only contain the h1, h2 .. h6 tags";

    /**
     * Error code representing presence of multiple heading tags within the title component div tag. The title component div tag must contain exactly one heading tag.
     */
    public static final String TITLE_COMPONENT_ONE_HEADING_TAG = "0413";//"The title component must contain exactly one heading tag";
}

