/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter;

/**
 * Exception to indicate the missing "marked" div. The HTML must wrap the target content within a < div > tag with id attribute specified as
 * cqcanvas. E.g.
 * <p>
 * < body ><br>
 * < div > Outer content is ignored < /div ><br>
 * < div id="cqcanvas" ><br>
 * < p >
 * Content within the cqcanvas marked div is considered for import.
 * < /p >
 * <br>
 * < /div ><br>
 * < /body ><br>
 */
public class MissingCanvasException extends DesignImportException {

    /** Serial Version UID */
    private static final long serialVersionUID = 1263614485758696971L;

    public MissingCanvasException() {
    }

    public MissingCanvasException(String message) {
        super(message);
    }

    public MissingCanvasException(Exception cause) {
        super(cause);
    }

    public MissingCanvasException(String message, Exception cause) {
        super(message, cause);
    }

}
