/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter;

import com.day.cq.wcm.designimporter.api.TagHandler;

/**
 * Exception thrown by {@link TagHandler}s when the tag being handled contains content that isn't supported by the {@link TagHandler}
 */
public class UnsupportedTagContentException extends DesignImportException {

    /** Serial Version UID */
    private static final long serialVersionUID = 3474273972420785952L;

    public UnsupportedTagContentException() {
        this("A tag content is unsupported. Please check the HTML and upload again.");
    }

    public UnsupportedTagContentException(String message) {
        super(message);
    }

    public UnsupportedTagContentException(Exception cause) {
        super(cause);
    }

    public UnsupportedTagContentException(String message, Exception cause) {
        super(message, cause);
    }

}
