/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.api;

/**
 * Constants used by design importer classes
 *
 * @since 5.6.1
 */
public interface ImporterConstants {

    /**
     * Resource Type of the importer component
     */
    String RESOURCE_TYPE_IMPORTER = "wcm/designimporter/components/importer";

    /**
     * Resource Type of the importer page
     */
    String RESOURCE_TYPE_IMPORTER_PAGE = "wcm/designimporter/components/importerpage";

    /**
     * Resource Type of the importer page
     */
    String PAGE_TEMPLATE_IMPORTER_PAGE = "/libs/wcm/designimporter/templates/importerpage";

    /**
     * Name of the canvas node
     */
    String NN_CANVAS = "canvas";

    /**
     * Name of the secondaryCanvas property. This property is used to differentiate
     * secondary canvases from primary
     */
    String PN_SECONDARY_CANVAS = "cq:secondaryCanvas";

    /**
     * Name of the ownerCanvasPage property. This property on canvas artifacts back refers
     * to the page that contains the canvas the artifact is associated with.
     */
    String PN_OWNER_CANVAS_PAGE = "cq:ownerCanvasPage";

    /**
     * Name of the canvasArtifactsPendingDelete property. This multi-valued property is put on
     * pages with cleared canvas to help deactivate the canvas artifacts when the page is
     * activated next
     */
    String PN_CANVAS_ARTIFACTS_PENDING_DEACTIVATE = "cq:canvasArtifactsPendingDeactivate";

    /**
     * Name of the design package node. Design package node, a child node of the importer node, acts as
     * a container for the design package file node
     */
    String NN_DESIGNPACKAGE = "designpackage";

    /**
     * Name of the design package file node
     */
    String NN_DESIGNPACKAGEFILE = "file";

    /**
     * Name of the jcr property that holds the reference to the dam asset that needs to be imported
     * via the design importer
     */
    String PN_DESIGN_PACKAGE_REFERENCE = "designPackageReference";

    /**
     * Name of the request parameter that holds the design package archive stream
     */
    String PARAM_DESIGNFILE = "designfile";

    /**
     * Name of the ComponentTagHandlerFactory's OSGi property that stores the resource type to be associated
     * with the component to be generated
     */
    String PN_RESOURCE_TYPE = "component.resourceType";
}
