/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/**
 * Utility class that maintains stacked counters which can be used as suffixes for uniquely identifying names.
 *
 */
public class ComponentSuffixGenerator {

    private Stack<Map<String, Integer>> stack;

    public ComponentSuffixGenerator() {
        reset();
    }

    /**
     * Gets the suffix for a component name. The suffix scheme is to use an incrementing counter.
     *
     * @param componentName The name of the component the suffix for which is desired
     * @return The suffix that uniquely identifies the component. If the api is consecutively called for the same component name, an incremented suffix value will be observed.
     */
    public String getSuffix(String componentName) {
        Map<String, Integer> nameMap = stack.peek();
        int suffix = -1;
        if (nameMap.containsKey(componentName)) {
            suffix = nameMap.get(componentName) + 1; // Increment
        }
        nameMap.put(componentName, suffix);
        return suffix > -1 ? "_" + suffix : "";
    }

    /**
     * Creates a new component stack for hierarchical suffixing. Same component names may bear the same suffix given that they are in different hierarchy levels
     */
    public void startComponentStack() {
        stack.push(new HashMap<String, Integer>());
    }

    /**
     * Ends a component stack
     */
    public void endComponentStack() {
        stack.pop();
    }

    /**
     * Resets the internal structures for maintaining the component stacks and suffixes
     */
    public void reset() {
        stack = new Stack<Map<String, Integer>>();
        stack.push(new HashMap<String, Integer>());
    }

}
