/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.util;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.indd.PageComponent;
import org.apache.jackrabbit.JcrConstants;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import java.util.Calendar;
import java.util.Set;

/**
 * Utility class for CQ component related repository operations
 */
public class ComponentUtil {

    static public void writeComponent(PageComponent component, Node parentNode, Session session) throws RepositoryException {
        String resourceType = component.getResourceType();
        String componentName = getComponentName(component);
        Node componentNode = JcrUtil.createUniqueNode(parentNode, componentName, JcrConstants.NT_UNSTRUCTURED, session);
        addDefaultProperties(componentNode);
        componentNode.setProperty("sling:resourceType", resourceType);
        Set<String> keys = component.getProperties().keySet();
        for (String key : keys) {
            String value = component.getProperties().get(key, "");
            componentNode.setProperty(key, value);
        }

        //recursively write all the nested components
        for (PageComponent childComponent : component.getChildComponents()) {
            writeComponent(childComponent, componentNode, session);
        }
    }


    static private void addDefaultProperties(Node componentNode) throws RepositoryException {
        String createdBy = componentNode.getSession().getUserID();
        Calendar now = Calendar.getInstance();
        componentNode.setProperty("jcr:createdBy", createdBy);
        componentNode.setProperty("jcr:created", now);
        componentNode.setProperty("jcr:lastModifiedBy", createdBy);
        componentNode.setProperty("jcr:lastModified", now);
    }

    static private String getComponentName(PageComponent component) {
        if (component.getNameHint() != null) {
            return JcrUtil.createValidName(component.getNameHint());
        } else {
            return getJcrNameFromType(component.getResourceType());
        }
    }

    static private String getJcrNameFromType(String resourceType) {
        String[] paths = resourceType.split("/");
        return JcrUtil.createValidName(paths[paths.length - 1]);
    }

}
