/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.mobile.api.device;

import java.util.Collection;

/**
 * The <code>DeviceGroupProvider</code> provides access to existing device groups.
 */
public interface DeviceGroupProvider {

    public static final String MOUNTPOINT_DEVICEGROUPS = "/etc/mobile/groups";

    /**
     * Returns the {@link DeviceGroup} as identified by its <code>name</code>. If no device group matches the given
     * name, <code>null</code> is returned.
     *
     * @param name The name of the desired device group.
     *
     * @return The device group with the given name, or <code>null</code> if not found.
     */
    DeviceGroup get(String name);

    /**
     * Returns all {@link DeviceGroup}s known to this provider.
     *
     * @return A <code>Collection</code> containing all known device groups.
     */
    Collection<DeviceGroup> getAll();

    /**
     * Tries to find a matching {@link DeviceGroup} using the provided {@link DeviceGroupPredicate}.
     *
     * @param predicate The predicate to find a match with.
     *
     * @return The matching <code>DeviceGroup</code> or <code>null</code> if none was found.
     */
    DeviceGroup find(DeviceGroupPredicate predicate);
}
