/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.msm.api;

import java.util.Map;
import java.util.Set;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import com.day.cq.wcm.api.WCMException;

/**
 * Provides a service to manage live actions
 * @deprecated since 5.5 access Actions via {@link com.day.cq.wcm.msm.api.RolloutConfig RolloutConfig} 
 */
@Deprecated
public interface ActionManager {
    /**
     * Returns all registred actions.
     * @return map of pairs (action name, LiveAction).
     */
    public Map<String,LiveAction> getRegistredActions();

    public LiveAction getAction(String name);

    /**
     * Execute actions found in relationship. Only registered actions will be executed.
     * @see LiveAction#execute(org.apache.sling.api.resource.ResourceResolver, LiveRelationship, ActionConfig, boolean)
     * @param resolver resource resolver
     * @param relation live relationship
     * @param autoSave  Save modifications
     * @throws WCMException occurs if one action is not registered or if action execution throws an exception
     */
    public void executeActions(ResourceResolver resolver, LiveRelationship relation, RolloutManager.Trigger trigger, boolean autoSave) throws WCMException;

    /**
     * Execute actions found in relationship. Only registered actions will be executed.
     * @see LiveAction#execute(org.apache.sling.api.resource.ResourceResolver, LiveRelationship, ActionConfig, boolean)
     * @param resolver resource resolver
     * @param relation live relationship
     * @param autoSave  Save modifications
     * @param isResetRollout True if rollout is run in reset mode
     * @throws WCMException occurs if one action is not registered or if action execution throws an exception
     */
    public void executeActions(ResourceResolver resolver, LiveRelationship relation, RolloutManager.Trigger trigger, boolean autoSave, boolean isResetRollout) throws WCMException;

    /**
     * Execute action defined by config. Note that actions found in relationship are not executed.
     * Only a registered action will be executed.
     * @see LiveAction#execute(org.apache.sling.api.resource.ResourceResolver, LiveRelationship, ActionConfig, boolean)
     * @param resolver resource resolver
     * @param relation live relationship
     * @param config defines actions to execute
     * @param autoSave  Save modifications
     * @throws WCMException occurs if one action is not registered or if action execution throws an exception
     */
    public void executeAction(ResourceResolver resolver, LiveRelationship relation, ActionConfig config, boolean autoSave) throws WCMException;

    /**
     * Execute action defined by config. Note that actions found in relationship are not executed.
     * Only a registered action will be executed.
     * @see LiveAction#execute(org.apache.sling.api.resource.ResourceResolver, LiveRelationship, ActionConfig, boolean)
     * @param resolver resource resolver
     * @param relation live relationship
     * @param config defines actions to execute
     * @param autoSave  Save modifications
     * @param isResetRollout True if rollout is run in reset mode
     * @throws WCMException occurs if one action is not registered or if action execution throws an exception
     */
    public void executeAction(ResourceResolver resolver, LiveRelationship relation, ActionConfig config, boolean autoSave, boolean isResetRollout) throws WCMException;

    /**
     * Returns a set of {@link ActionConfig} store under the defined root.
     * @param root The root to read the action configs
     * @return A set of {@link ActionConfig}, or an empty set if not config found
     * @throws RepositoryException may occur while reading the repository.
     */
    public Set<ActionConfig> getActionsConfig(Resource root) throws RepositoryException;

    /**
     * Returns a set of {@link ActionConfig} store under the defined root.
     * @param root The root to read the action configs
     * @return A set of {@link ActionConfig}, or an empty set if not config found
     * @throws RepositoryException may occur while reading the repository.
     */
    public Set<ActionConfig> getActionsConfig(Node root) throws RepositoryException;
}
