/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.msm.api;


import java.util.Set;

import com.day.cq.wcm.api.WCMException;

/**
 * Provides access to Roll-out Configuration.<br>
 * The configurations served by this manager are centrally maintained.
 * They can be accessed via their path, which is their identifier.
 * The reference is resolved by the RolloutConfiguration's
 * {@link com.day.cq.wcm.msm.api.RolloutConfig#getPath() path}<br>
 * The Manager is bound to the requesting Session.
 *
 * @see RolloutConfig
 * @see LiveRelationshipManager
 * @since 5.5
 */
public interface RolloutConfigManager {

    /**
     * @return set of paths to Roll-out configuration, readable for this instance
     * @throws WCMException in case of error accessing the paths
     */
    public Set<String> getRolloutConfigs() throws WCMException;

    /**
     * @param path of the RolloutConfig to access
     * @return RolloutConfig or <code>null</code> if there is no config present
     *         for the requested path
     * @throws WCMException in case of eror accessing the config
     */
    public RolloutConfig getRolloutConfig(String path) throws WCMException;
}
