/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.msm.commons;

import java.util.Dictionary;

import org.osgi.service.component.ComponentContext;

import com.day.cq.wcm.msm.api.RolloutManager;

/**
 * A {@code BaseActionFactory} extension that provides basic support to set-up filtering configuration.
 */
public abstract class FilteredActionFactoryBase<ActionType extends FilteredAction> extends BaseActionFactory<ActionType> {

    private ItemFilterImpl pagePropertyFilter;

    private ItemFilterImpl paragraphFilter;

    /**
     * Initializes the filters
     * <br>
     * This method should be called on activation and modification of your Service.
     * </p>
     * Two ItemFilter are created by the help of the {@link com.day.cq.wcm.msm.commons.ItemFilterUtil ItemFilterUtil}.
     * One dedicated for the Page-level, to be applied on the Page's content.
     * Its referred to as the pagePropertyFilter accessed with {@link #getPagePropertyFilter() getPagePropertyFilter()}
     * The other other ItemFilter for child-nodes of the Page content at any level.
     * It is accessed via the {@link #getComponentFilter() #getComponentFilter()}.
     *
     * @param componentContext Provide access to the Component's configuration
     * @param rolloutManager   to setUp the Filter from the Component's configuration
     * @see ItemFilterUtil#createPageFilter(java.util.Dictionary, com.day.cq.wcm.msm.api.RolloutManager)
     * @see ItemFilterUtil#createComponentFilter(java.util.Dictionary, com.day.cq.wcm.msm.api.RolloutManager)
     * @see ItemFilterImpl
     */
    protected void setupFilter(ComponentContext componentContext, RolloutManager rolloutManager) {
        Dictionary properties = componentContext.getProperties();

        //on page-level only add the pageProperties, the jcr:content only can be denied by Node-Type
        pagePropertyFilter = ItemFilterUtil.createPageFilter(properties, rolloutManager);
        paragraphFilter = ItemFilterUtil.createComponentFilter(properties, rolloutManager);
    }

    /**
     * @return a {@code ItemFilterImpl} that needs to be applied at Page level. Maybe <code>null</code>
     */
    protected ItemFilterImpl getPagePropertyFilter() {
        return pagePropertyFilter;
    }

    /**
     * @return a {@code ItemFilterImpl} that needs to be applied at Component level. Maybe <code>null</code>
     */
    protected ItemFilterImpl getComponentFilter() {
        return paragraphFilter;
    }
}