/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.notification;

import org.osgi.service.event.Event;

/**
 * A <code>Channel</code> is used in the notification framework to
 * publish an event.
 * If an event occurs and if there is a subscription matching this
 * event, the subscription is associated with a channel and the
 * channel is invoked to publish this event.
 */
public interface Channel {

    /**
     * Publish the event through this channel.
     * @param context      The notification context.
     * @param event        The event that occured.
     * @throws Exception
     */
    void publish(NotificationContext context, Event event)
    throws Exception;

}
