/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.notification;

import javax.jcr.Session;

import org.apache.sling.api.resource.PersistableValueMap;

import com.day.cq.security.Authorizable;

/**
 * A <code>NotificationContext</code> allows access to several
 * useful things..
 */
public interface NotificationContext {

    /**
     * Return an admin session for the channel.
     * @return A session.
     * @deprecated
     * @use {@link slingRepository.impersonateFromService()}
     */
    Session getAdministrativeSession();

    /**
     * Return the current user.
     * @return The current user.
     * @deprecated
     * @use {@link NotificationContext.getAuthorizable()}
     */
    Authorizable getUser();

    /**
     * Return the configuration.
     * @return The current user configuration.
     */
    PersistableValueMap getConfiguration();
    
    /**
     * Returns the authorizable associated with a service session which has limited privileges.
     * This authorizable has read permissions on home/users but can write only to wcm/notification. 
     * @return the authorizable.
     */
    org.apache.jackrabbit.api.security.user.Authorizable getAuthorizable();
}
