/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.notification;

import java.util.Iterator;
import java.util.Map;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.apache.sling.api.resource.PersistableValueMap;
import org.apache.sling.api.resource.ValueMap;

import com.day.cq.security.Authorizable;

/**
 * The notification manager manages the notification and subscription
 * configurations.
 * It can be used to query the configurations for a given authorizable
 * update and create them.
 */
public interface NotificationManager {

    /**
     * Return all subscriptions for a given authorizable.
     * @param authorizable The authorizable.
     * @return An iterator for the subscription configurations.
     * @deprecated Use {@link NotificationManager#getSubscriptionConfigurations(org.apache.jackrabbit.api.security.user.Authorizable, Session)} instead
     */
    Iterator<PersistableValueMap> getSubscriptionConfigurations(Authorizable authorizable);
    
    /**
     * Return all subscriptions for a given authorizable.
     * @param authorizable The authorizable.
     * @return An iterator for the subscription configurations.
     */
    Iterator<PersistableValueMap> getSubscriptionConfigurations(org.apache.jackrabbit.api.security.user.Authorizable authorizable, Session session);

    /**
     * Return all channel configurations for a given authorizable.
     * @param authorizable The authorizable.
     * @return An iterator for the channel configurations.
     * @deprecated Use {@link NotificationManager#getChannelConfigurations(org.apache.jackrabbit.api.security.user.Authorizable, Session)} instead
     */
    Iterator<PersistableValueMap> getChannelConfigurations(Authorizable authorizable);
    
    /**
     * Return all channel configurations for a given authorizable.
     * @param authorizable The authorizable.
     * @return An iterator for the channel configurations.
     */
    Iterator<PersistableValueMap> getChannelConfigurations(org.apache.jackrabbit.api.security.user.Authorizable authorizable, Session session);

    /**
     * Return the channel.
     * @param type The channel type.
     * @return The channel or <code>null</code>
     */
    Channel getChannel(String type);

    /**
     * Return the subscription.
     * @param type The subscription type.
     * @return The subscription or <code>null</code>
     */
    Subscription getSubscription(String type);

    /**
     * Return the channel configuration for the subscription.
     * @param authorizable The authorizable.
     * @param subscriptionConfig The subscription configuration.
     * @return The channel configuration or <code>null</code>
     * @deprecated Use {@link NotificationManager#getChannelConfigurations(org.apache.jackrabbit.api.security.user.Authorizable, Map, Session)} instead
     */
    PersistableValueMap getChannelConfiguration(Authorizable authorizable, Map subscriptionConfig);
    
    /**
     * Return the channel configuration for the subscription.
     * @param authorizable The authorizable.
     * @param subscriptionConfig The subscription configuration.
     * @return The channel configuration or <code>null</code>
     */
    PersistableValueMap getChannelConfiguration(org.apache.jackrabbit.api.security.user.Authorizable authorizable, Map subscriptionConfig, Session session);
    
    /**
     * Return the node for the settings of the notification module
     * of an authorizable.
     *
     * @param authorizable The authorizable.
     * @return The node.
     * @throws RepositoryException Upon encountering a repository error getting the notification node.
     * @deprecated Use {@link NotificationUtil#getNotificationNode(Authorizable)} instead
     */
    @Deprecated
    Node getNotificationNode(Authorizable authorizable)
    throws RepositoryException;

    /**
     * Create a new subscription for the authorizable.
     * @param authorizable The authorizable.
     * @param configuration The configuration.
     * @return <code>true</code> if the configuration could be created, <code>false</code> otherwise.
     * @deprecated Use {@link #subscribe(com.day.cq.security.Authorizable, java.util.Map)} instead
     */
    @Deprecated
    boolean createSubscription(Authorizable authorizable, ValueMap configuration);

    /**
     * Remove the subscription.
     * @param authorizable The authorizable.
     * @param configuration The configuration.
     * @return <code>true</code> if the configuration could be removed, <code>false</code> otherwise.
     * @deprecated Use {@link #unsubscribe(com.day.cq.security.Authorizable, String)} instead.
     */
    @Deprecated
    boolean removeSubscription(Authorizable authorizable, PersistableValueMap configuration);

    /**
     * Create a new subscription for the authorizable.
     *
     * @param authorizable  The authorizable.
     * @param configuration The configuration.
     *
     * @return <code>true</code> if the configuration could be created, <code>false</code> otherwise.
     * @deprecated Use {@link NotificationManager#subscribe(org.apache.jackrabbit.api.security.user.Authorizable, Map<String, Object>, Session)} instead
     */
    boolean subscribe(Authorizable authorizable, Map<String, Object> configuration);
    
    /**
     * Create a new subscription for the authorizable.
     *
     * @param authorizable  The authorizable.
     * @param configuration The configuration.
     * @param session User's session.
     *
     * @return <code>true</code> if the configuration could be created, <code>false</code> otherwise.
     */
    boolean subscribe(org.apache.jackrabbit.api.security.user.Authorizable authorizable, Map<String, Object> configuration, Session session);

    /**
     * Remove all subscriptions matching the given <code>path</code>. The <code>path</code> denotes the item
     * the user originally subscribed for.
     *
     * @param authorizable The authorizable.
     * @param path         The path of the subscription to remove.
     *
     * @return <code>true</code> if the configuration could be removed, <code>false</code> otherwise.
     * @deprecated Use {@link NotificationManager#unsubscribe(org.apache.jackrabbit.api.security.user.Authorizable, String, Session)} instead
     */
    boolean unsubscribe(Authorizable authorizable, String path);
    
    /**
     * Remove all subscriptions matching the given <code>path</code>. The <code>path</code> denotes the item
     * the user originally subscribed for.
     *
     * @param authorizable The authorizable.
     * @param path         The path of the subscription to remove.
     * @param session User's session.
     *
     * @return <code>true</code> if the configuration could be removed, <code>false</code> otherwise.
     */
    boolean unsubscribe(org.apache.jackrabbit.api.security.user.Authorizable authorizable, String path, Session s);
}
