/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.notification;

import com.day.cq.security.Authorizable;
import com.day.cq.wcm.notification.impl.NotificationManagerImpl;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import java.util.Map;

/**
 * Utility class for notifications.
 */
public abstract class NotificationUtil {

    /**
     * The configuration property holding the channel type.
     */
    public static final String PROPERTY_CHANNEL_TYPE = "type";

    /**
     * The configuration property holding the channel type.
     */
    public static final String PROPERTY_CHANNEL_NAME = "channel";

    /**
     * The configuration property holding the subscription type.
     */
    public static final String PROPERTY_SUBSCRIPTION_TYPE = "type";

    /**
     * Return the channel type for the config.
     *
     * @param channelConfig The channel configuration.
     *
     * @return The channel type or <code>null</code>
     */
    public static String getChannelType(final Map channelConfig) {
        return (null != channelConfig) ? (String) channelConfig.get(PROPERTY_CHANNEL_TYPE) : null;
    }

    /**
     * Return the channel name for the config.
     *
     * @param subscriptionConfig The subscription configuration.
     *
     * @return The channel name or <code>null</code>
     */
    public static String getChannelName(final Map subscriptionConfig) {
        return (null != subscriptionConfig) ? (String) subscriptionConfig.get(PROPERTY_CHANNEL_NAME) : null;
    }

    /**
     * Return the subscription type for the config.
     *
     * @param subscriptionConfig The subscription configuration.
     *
     * @return The subscription type or <code>null</code>
     */
    public static String getSubscriptionType(final Map subscriptionConfig) {
        return (null != subscriptionConfig) ? (String) subscriptionConfig.get(PROPERTY_SUBSCRIPTION_TYPE) : null;

    }

    /**
     * Return the node for the settings of the notification module of an authorizable.
     *
     * @param authorizable The authorizable.
     *
     * @return The node or <code>null</code> if not possible to get the node
     *
     * @throws RepositoryException Upon encountering a repository error getting the notification node.
     * @since 5.4
     * @deprecated Use {@link NotificationUtil#getNotificationNode(String, javax.jcr.Session)} instead
     */
    public static Node getNotificationNode(Authorizable authorizable)
            throws RepositoryException {
        final Node n = authorizable.adaptTo(Node.class);
        if (n != null) {
            return getNotificationNode(authorizable, n.getSession());
        }
        return null;
    }


    /**
     * Return the node for the settings of the notification module of an authorizable.
     *
     * @param authorizable The authorizable.
     * @param s            The session to get the node
     *
     * @return The node
     *
     * @throws RepositoryException Upon encountering a repository error getting the notification node.
     * @since 5.4
     * @deprecated Use {@link NotificationUtil#getNotificationNode(String, javax.jcr.Session)} instead
     */
    public static Node getNotificationNode(final Authorizable authorizable, final Session s)
            throws RepositoryException {
        final Node authorizableHome = (Node) s.getItem(authorizable.getHomePath());
        boolean save = false;
        if (!authorizableHome.hasNode(NotificationManagerImpl.PRODUCT_PREFIX)) {
            authorizableHome.addNode(NotificationManagerImpl.PRODUCT_PREFIX, NotificationManagerImpl.FOLDER_NODETYPE);
            save = true;
        }
        final Node productNode = authorizableHome.getNode(NotificationManagerImpl.PRODUCT_PREFIX);
        if (!productNode.hasNode(NotificationManagerImpl.SUB_PRODUCT_PREFIX)) {
            productNode.addNode(NotificationManagerImpl.SUB_PRODUCT_PREFIX, NotificationManagerImpl.FOLDER_NODETYPE);
            save = true;
        }
        if (save) {
            s.save();
        }
        return productNode.getNode(NotificationManagerImpl.SUB_PRODUCT_PREFIX);
    }
    
    /**
     * Return the node for the settings of the notification module of an authorizable.
     *
     * @param authorizablePath The path of the authorizable.
     * @param s            The session to get the node
     *
     * @return The node
     *
     * @throws RepositoryException Upon encountering a repository error getting the notification node.
     * @since 6.2
     */
    public static Node getNotificationNode(final String authorizablePath, final Session s)
            throws RepositoryException {
        final Node authorizableHome = (Node) s.getItem(authorizablePath);
        boolean save = false;
        if (!authorizableHome.hasNode(NotificationManagerImpl.PRODUCT_PREFIX)) {
            authorizableHome.addNode(NotificationManagerImpl.PRODUCT_PREFIX, NotificationManagerImpl.FOLDER_NODETYPE);
            save = true;
        }
        final Node productNode = authorizableHome.getNode(NotificationManagerImpl.PRODUCT_PREFIX);
        if (!productNode.hasNode(NotificationManagerImpl.SUB_PRODUCT_PREFIX)) {
            productNode.addNode(NotificationManagerImpl.SUB_PRODUCT_PREFIX, NotificationManagerImpl.FOLDER_NODETYPE);
            save = true;
        }
        if (save) {
            s.save();
        }
        return productNode.getNode(NotificationManagerImpl.SUB_PRODUCT_PREFIX);
    }
}
