/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.notification;

import org.osgi.service.event.Event;

/**
 * A subscription is an abstraction defining the possibilities to
 * get notified when an event occurs.
 *
 * Examples are page modifications or content updates etc.
 */
public interface Subscription {

    /**
     * Does this subscription match the incoming event?
     * @param context The notification context.
     * @param event   The event.
     * @return <code>true</code> if the user is interested in this event.
     */
    boolean matches(NotificationContext context, Event event);
}
