/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.notification.email;

import com.day.cq.wcm.notification.NotificationContext;
import org.apache.commons.mail.Email;
import org.osgi.service.event.Event;

/**
 * The <code>EmailBuilder</code> builds {@link Email}s based on a given {@link NotificationContext} and {@link Event}.
 * The builders are OSGi services that are looked up as service references while sending an email for an occurring
 * notification.
 * <p/>
 * Email builders are specific to a {@link Event} type, and as such must provide an scr property named "topic"
 * indicating the event topic it wants to process.
 */
public interface EmailBuilder {

    /**
     * Indicates whether this email builder accepts the given {@link NotificationContext} and {@link Event} to build an
     * email from.
     *
     * @param context The notification context.
     * @param event   The event.
     *
     * @return <code>true</code> if the email builder accepts the context and event.
     */
    boolean accepts(NotificationContext context, Event event);

    /**
     * Indicates whether this email builder should build the email given the {@link NotificationContext} and {@link Event}
     *
     * @param context The notification context.
     * @param event   The event.
     *
     * @return <code>true</code> if the email builder should build the email.
     */
    boolean shouldBuild(NotificationContext context, Event event);
    
    /**
     * Builds an email message from the given notification context and event.
     *
     * @param context     The notification context.
     * @param event       The event.
     * @param addressFrom The address from with to send the email.
     *
     * @return An email.
     */
    Email build(NotificationContext context, Event event, final String addressFrom);
}
