/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.offline;

/**
 * Convenience class for HTML generation.
 */
public class HtmlUtil {

    /**
     * Escape suitably for HTML text content
     */
    public static String escapeHtmlText(String input) {
        return input.replace("&", "&amp").replace("<", "&lt;").replace(">", "&gt;");
    }

    /**
     * Escape suitably for HTML attribute content
     */
    public static String escapeHtmlAttr(String input) {
        return input.replace("&", "&amp").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'",  "&#39;");
    }
}
